

// var theNewScript = document.createElement("script");
// theNewScript.type = "text/javascript";
//// theNewScript.src = "https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js";
// theNewScript.src = "file:///Users/aamirkhanov/Documents/jquery.min.js";
// document.getElementsByTagName("head")[0].appendChild(theNewScript);

var TAG_CHAR = "\uFE19"; //character we insert into the original string to "bind" tags onto it - a la attributed string

function loadScript(url, callback) {
    
    var script = document.createElement("script")
    script.type = "text/javascript";
    
    if (script.readyState) { //IE
        script.onreadystatechange = function () {
            if (script.readyState == "loaded" || script.readyState == "complete") {
                script.onreadystatechange = null;
                callback();
            }
        };
    } else { //Others
        script.onload = function () {
            callback();
        };
    }
    
    script.src = url;
    document.getElementsByTagName("head")[0].appendChild(script);
}


var stringArr = [];
var breakAdded = false;

function getColorArr(colorStr){
    var colorArr = [];
    if (colorStr.substring(0,4) == "rgba")
        colorArr = colorStr.substring(5, colorStr.length-1).replace(/ /g, '').split(',');
    else {
        colorArr = colorStr.substring(4, colorStr.length-1).replace(/ /g, '').split(',');
        colorArr.push(1);
    }
    return colorArr;
}

function getLink(srcLink){
    if(!srcLink) return "";
    if(srcLink.substring(0,1) == "#")
        return window.location.href + srcLink;
    if (srcLink.substring(0,2)=="//") {
        if (window.location.protocol == "file:" || window.location.protocol == "about:")
            srcLink = "http://" + srcLink.substring(2,srcLink.length);
        else
            srcLink = window.location.protocol + srcLink;
    }
    else if (!srcLink.includes("://")){
        if(srcLink.substring(0,1)=="/")
            srcLink = window.location.origin + srcLink;
        else
            srcLink = window.location.origin + "/" + srcLink;
    }
    return srcLink.trim();
}

function getTableAttrs(e){
    var map = {'message':TAG_CHAR};
    
    if(e.getAttribute('colspan'))
        map['colspan'] = e.getAttribute('colspan');
    if(e.getAttribute('rowspan'))
        map['rowspan'] = e.getAttribute('rowspan');
    
    map['borderLeftColor'] = getColorArr($(e).css('border-left-color'));
    map['borderRightColor'] = getColorArr($(e).css('border-right-color'));
    map['borderTopColor'] = getColorArr($(e).css('border-top-color'));
    map['borderBottomColor'] = getColorArr($(e).css('border-bottom-color'));
    map['backgroundColor'] = getColorArr($(e).css('background-color'));
    
    return map;
}

function getAttrs(e){
    var elParent = $(e).parent();
    var map = {'message':''};
    map['tag'] = "kOUTextNode";
    map['fontSize'] = elParent.css('font-size').replace(/[^\d,\.]+/g, '');
    map['fontWeight'] = elParent.css('font-weight');
    map['fontStyle'] = elParent.css('font-style');
    map['textDecoration'] = elParent.css('text-decoration');
    map['textDecorationColor'] = getColorArr(elParent.css('text-decoration-color'));
    
    var fc = getColorArr(elParent.css('color'));
    var bc = getColorArr(elParent.css('background-color'));
    if (fc[0] > 250 && fc[1] > 250 && fc[2] > 250 &&
        ((bc[0] > 240 && bc[1] > 240 && bc[2] > 240) || bc[3] < 0.3))
        map['fontColor'] = [200,200,200,1];
    else
        map['fontColor'] = fc;
    map['backgroundColor'] = getColorArr(elParent.css('background-color'));
    
    map['fontFamily'] = elParent.css('font-family').replace(/'/g,'').replace(/"/g,'').split(", ");
    map['textAlign'] = elParent.css('text-align');
    map['textIndent'] = elParent.css('text-indent').replace(/[^\d,\.]+/g, '');
    map['wordWrap'] = elParent.css('word-wrap');
    map['wordBreak'] = elParent.css('word-break');
    map['maxHeight'] = elParent.css('max-height').replace(/[^\d,\.]+/g, '');
    map['minHeight'] = elParent.css('min-height').replace(/[^\d,\.]+/g, '');
    map['lineHeight'] = elParent.css('line-height').replace(/[^\d,\.]+/g, '');
    map['marginLeft'] = elParent.css('margin-left').replace(/[^\d,\.]+/g, '');
    map['marginRight'] = elParent.css('margin-right').replace(/[^\d,\.]+/g, '');
    map['marginTop'] = elParent.css('margin-top').replace(/[^\d,\.]+/g, '');
    map['marginBottom'] = elParent.css('margin-bottom').replace(/[^\d,\.]+/g, '');
    
    if($(e).parents().filter(function(i,item){
                             //var verticalAlign = $(e).parent().css('vertical-align');
                             var verticalAlign = $(item).css('vertical-align');
                             var superScript = item.nodeName;
                             return (verticalAlign != 'super' || superScript != "SUP")}).length != $(e).parents().length)
        map['script'] = "super";
    
    if($(e).parents().filter(function(i,item){
                             //var verticalAlign = $(e).parent().css('vertical-align');
                             var verticalAlign = $(item).css('vertical-align');
                             var superScript = item.nodeName;
                             return (verticalAlign != 'sub' || superScript != "SUB")}).length != $(e).parents().length)
        map['script'] = "sub";
    
    var elParentCopy = elParent;
    while(elParentCopy){
        if(elParentCopy.tagName == 'A') {
            map['link'] = elParentCopy.getAttribute('href');
            break;
        }
        elParentCopy = elParentCopy.parentNode;
    }
    return map;
}

function beginText(e) {
    if ($(e).parent().css("visibility") == "hidden") return;
    if ($(e).parent().css("display") == "none") return;
    if ($(e).parent().css("opacity") == "0") return;
    try
    {
        if ($(e).css("opacity") == "0") return;
    }
    catch(e) {}
    if ($(e).parent().nodeName == "STYLE") return;
    if ($(e).parent().nodeName == "SCRIPT") return;
    if ($(e).parent().nodeName == "NOSCRIPT") return;
    if (e.parentNode.nodeName == "STYLE") return;
    if (e.parentNode.nodeName == "SCRIPT") return;
    if (e.parentNode.nodeName == "NOSCRIPT") return;
                                                            
    //if (e.textContent.replace(/\s+/g,"").length == 0) return;
    
    var col = getAttrs(e);
    col["message"] = e.textContent.replace(/\r?\n/g, " ");
    if(e.textContent.substring(e.textContent.length - 3,e.textContent.length) == "   " || e.textContent.substring(0,3).replace(/\r?\n/g, " ") == "   ")
        col["message"] = e.textContent.trim();
    //col["message"] = e.textContent;
    
    if($(e).parent().css("display") == "block" && $(e).parent().contents().first().text() == e.textContent && stringArr.length > 0){
        var tempArr = stringArr.filter(function(item){
                                       return item["message"] != TAG_CHAR});
        if (tempArr.length){
            var mes = tempArr[tempArr.length-1]["message"];
            if(mes.substring(mes.length-1, mes.length) != "\n")
                col["message"] = "\n" + col["message"];
        }
    }
    stringArr.push(col);
    breakAdded = false;
    
    //callback({ "text" : e.text()});
}

function endText(e) {
    
    if(breakAdded) return;
    if ($(e).parent().contents().last().text() != e.textContent && $(e).parent().contents().last().text().replace(/\s+/g,'').length != 0) return;
    if ($(e).parent().contents().last().prev()) {
        if ($(e).parent().contents().last().prev().text() != e.textContent && $(e).parent().contents().last().text().replace(/\s+/g,'').length == 0) return;
    }
    //if ($(e).parent().css("display") == "block" || $(e).parent().css("display") == "list-item") {
    if ($(e).parent().css("display") == "block" || ($(e).parent().css("display") == "inline-block")) {
        var col = getAttrs(e);
        col["message"] = "\n";
        stringArr.push(col);
        breakAdded = true;
    }
}

//////////TABLES
function beginTable(e) {
    var col = getTableAttrs(e);
    col["tag"] = "kOUTableBegin";
    stringArr.push(col);}

function endTable(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableEnd"};
    stringArr.push(col);}

function beginTableCaption(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableCaptionBegin"};
    stringArr.push(col);}

function endTableCaption(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableCaptionEnd"};
    stringArr.push(col);}

function beginTableHead(e) {
    var col = getTableAttrs(e);
    col["tag"] = "kOUTableHeadBegin";
    stringArr.push(col);}

function endTableHead(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableHeadEnd"};
    stringArr.push(col);}

function beginTableRaw(e) {
    var col = getTableAttrs(e);
    col["tag"] = "kOUTableRawBegin";
    stringArr.push(col);}

function endTableRaw(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableRawEnd"};
    stringArr.push(col);}

function beginTableData(e) {
    var col = getTableAttrs(e);
    col["tag"] = "kOUTableDataBegin";
    stringArr.push(col);}

function endTableData(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUTableDataEnd"};
    stringArr.push(col);}

/////////lists
function beginList(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUListBegin", "listStyleType" : $(e).css("list-style-type")};
    stringArr.push(col);}

function endList(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUListEnd"};
    stringArr.push(col);}

function beginListItem(e) {
    var listType = $(e).css("list-style-type");
    var col = {"message":TAG_CHAR, "tag" : "kOUListItemBegin"};
    
    if (listType != "none") {
        col["listStyleType"] = listType;
        stringArr.push(col);
        return;
    }
    
    if($(e).parent().css("list-style-type") != "none") {
        col["listStyleType"] = $(e).parent().css("list-style-type");
        stringArr.push(col);
        return;
    }
    
    var childs = $(e).contents().filter(function(i,item){return item.textContent.trim() != ""});
    
    while (childs.length) {
        if (childs.length > 1 && childs[0].textContent.replace(/[\d,\.]+/g, "") == "") {
            listType = "noneTypeOrdered";
            break;
        }
        childs = $(childs[0]).contents().filter(function(i,item){return item.textContent.trim() != ""});
    }
    
    col["listStyleType"] = listType;
    stringArr.push(col);}

function endListItem(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUListItemEnd"};
    stringArr.push(col);}

function endListItem(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOUListItemEnd"};
    stringArr.push(col);}

function beginLink(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOULinkStart", "href" : getLink(e.getAttribute("href")), "hrefOrig" : e.getAttribute("href")};
    stringArr.push(col);}

function endLink(e) {
    var col = {"message":TAG_CHAR, "tag" : "kOULinkEnd", "href" : getLink(e.getAttribute("href")), "hrefOrig" : e.getAttribute("href")};
    stringArr.push(col);}

function beginImg(e) {
    if (!$(e).attr("src")) return;
    if (getLink($(e).attr("src"))) {
        var col = {"message":TAG_CHAR, "tag" : "kOUImg", "imgSrc" : getLink($(e).attr("src")), "imgAlt" : $(e).attr("alt"), "width":$(e).attr("width"), "height":$(e).attr("height")};
        stringArr.push(col);}
    else if (getLink($(e).attr("srcset"))){
        var col = {"message":TAG_CHAR, "tag" : "kOUImg", "imgSrc" : getLink($(e).attr("srcset").split(/[\s,]+/)[0]), "imgAlt" : $(e).attr("alt"), "width":$(e).attr("width"), "height":$(e).attr("height")};
        stringArr.push(col);}
    }
                                                            
function beginDiv(e) {
    if($(e).css('position') != 'absolute') return;
    if($(e).parents().filter(function(){
                             var position = $(this).css('position');
                             return position == 'static'}).length != $(e).parents().length) return;
    var col = {"message":TAG_CHAR, "tag" : "kOUAbsoluteDivStart"};
    
    col["left"] = $(e).css("left").replace(/[^\d,\.]+/g, "");
    if(col["left"] == "") col["left"] = 0;
    
    col["right"] = $(e).css("right").replace(/[^\d,\.]+/g, "");
    if(col["right"] == "") col["right"] = 0;
    
    col["top"] = $(e).css("top").replace(/[^\d,\.]+/g, "");
    if(col["top"] == "") col["top"] = 0;
    
    col["bottom"] = $(e).css("bottom").replace(/[^\d,\.]+/g, "");
    if(col["bottom"] == "") col["bottom"] = 0;
    
    stringArr.push(col);}

function endDiv(e) {
    if($(e).css('position') != 'absolute') return;
    if($(e).parents().filter(function(){
                             var position = $(this).css('position');
                             return position == 'static'}).length != $(e).parents().length) return;
    var col = {"message":TAG_CHAR, "tag" : "kOUAbsoluteDivEnd"};
    stringArr.push(col);}

function beginBr(e) {
    var col = getAttrs(e);
    col["message"] = "\n";
    stringArr.push(col);}

function beginElem(e) {
    //if ($(e).css("display") == "none") return;
    if (e.nodeType == 3 && $(e).contents().length == 0) //text
        beginText(e);
    else if (e.nodeName == "TABLE")
        beginTable(e);
    else if (e.nodeName == "CAPTION")
        beginTableCaption(e);
    else if (e.nodeName == "TH")
        beginTableHead(e);
    else if (e.nodeName == "TR")
        beginTableRaw(e);
    else if (e.nodeName == "TD")
        beginTableData(e);
    else if (e.nodeName == "UL" || e.nodeName == "OL")
        beginList(e);
    else if (e.nodeName == "LI")
        beginListItem(e);
    else if (e.nodeName == "A")
        beginLink(e);
    else if (e.nodeName == "IMG")
        beginImg(e);
    else if (e.nodeName == "DIV")
        beginDiv(e);
    else if (e.nodeName == "BR")
        beginBr(e);
    
}

function endElem(e) {
    //if (e.nodeType == 3 && $(e).contents().length == 0)
    //if(true)
    //endText(e);
    if (e.nodeName == "TABLE")
        endTable(e);
    else if (e.nodeName == "CAPTION")
        endTableCaption(e);
    else if (e.nodeName == "TH")
        endTableHead(e);
    else if (e.nodeName == "TR")
        endTableRaw(e);
    else if (e.nodeName == "TD")
        endTableData(e);
    else if (e.nodeName == "UL" || e.nodeName == "OL")
        endList(e);
    else if (e.nodeName == "LI")
        endListItem(e);
    else if (e.nodeName == "A")
        endLink(e);
    else if (e.nodeName == "DIV")
        endDiv(e);
    endText(e);
}


function traverse(e) {
                                                            
    if (e == null) return;
    if (!jQuery.contains(document.documentElement, $(e)[0])) return;

    try
    {
         if($(e).css("opacity") == 0) return;
         if($(e).css("display") == "none") return;
    }
    catch(e) {}

    if(e.nodeName == "YATAG") return;
    if(e.nodeName == "#comment") return;
    beginElem(e);
    //!!if($(e).css("display") != "none" && $(e).css("visibility") != "hidden")
    $(e).contents().each(function(i,c){
                         //if(!$(e).is(":visible"))
                         traverse(c);
                         });
    endElem(e);
}

//traverse($(document.body));
//console.log(stringArr);

//window.webkit.messageHandlers.sendMessage.postMessage([{"message":"tempmessage"}]);
                                                            
function startParsing() {
    try {
           window.webkit.messageHandlers.JQTimeHandler.postMessage("start traverse: " + getCurrentTime());
           traverse($(document.body));
           window.webkit.messageHandlers.JQTimeHandler.postMessage("end traverse: " + getCurrentTime());
        //if(stringArr.length > 5) {
           window.webkit.messageHandlers.JQResultHandler.postMessage(stringArr);
    }
    catch(e) {
           window.webkit.messageHandlers.JSExceptionHandler.postMessage("Exception happened in JS: "+ e);
    }

}
                                                          
window.webkit.messageHandlers.JQTimeHandler.postMessage("start JS: " + getCurrentTime());

startParsing();

           
function getCurrentTime() {
    var today = new Date();
    var minutes = today.getMinutes();
    var seconds = today.getSeconds();
    var miliSeconds = today.getMilliseconds();
    var time = " " + minutes + ":" + seconds + ":" + miliSeconds + "\n";
    return time;
                                                            
}
                                                            
//setTimeout(function(){
//           window.webkit.messageHandlers.sendMessage.postMessage([{"message":typeof jQuery}]);
//},2000);
                                                            
                                                            
                                                            
                                                            
