//
//  JSPreprocessing.js
//  OutlineExt
//

/*
 * Copyright (c) 2010 Apple Inc. All rights reserved.
 */
function characterNeedsScoreMultiplier(e) {
	if (!e || e.length === 0)
		return !1;
	var t = e.charCodeAt(0);
	return t > 11904 && t < 12031?!0 : t > 12352 && t < 12543?!0 : t > 12736 && t < 19903?!0 : t > 19968 && t < 40959?!0 : t > 44032 && t < 55215?!0 : t > 63744 && t < 64255?!0 : t > 65072 && t < 65103?!0 : t > 131072 && t < 173791?!0 : t > 194560 && t < 195103?!0 : !1
}
function domDistance(e, t, n) {
	var r = [], i = e;
	while (i)
		r.unshift(i), i = i.parentNode;
	var s = [];
	i = t;
	while (i)
		s.unshift(i), i = i.parentNode;
	var o = Math.min(r.length, s.length), u = Math.abs(r.length - s.length);
	for (var a = o; a >= 0; --a) {
		if (r[a] === s[a])
			break;
		u += 2;
		if (n && u >= n)
			return n
	}
	return u
}
function fontSizeFromComputedStyle(e, t) {
	var n = parseInt(e.fontSize);
	return isNaN(n) && (n = t ? t : BaseFontSize), n
}
function contentTextStyleForNode(e, t) {
	function n(e) {
		if (isNodeWhitespace(e))
			return null;
		var t = getComputedStyle(e.parentNode);
		return t.float !== "none" ? null : t
	}
	var r = "descendant::text()[not(parent::h1) and not(parent::h2) and not(parent::h3) and not(parent::h4) and not(parent::h5) and not(parent::h6)]", i = e.evaluate(r, t, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), s = i.snapshotLength;
	for (var o = 0; o < s; ++o) {
		var u = n(i.snapshotItem(o));
		if (u)
			return u
	}
	return null
}
function isNodeWhitespace(e) {
	return !e || e.nodeType !== Node.TEXT_NODE?!1 : !/\S/.test(e.data)
}
function removeWhitespace(e) {
	return e.replace(/\s+/g, "")
}
function isElementNode(e) {
	return e && e.nodeType === Node.ELEMENT_NODE?!0 : !1
}
function isElementVisible(e) {
	var t = getComputedStyle(e);
	if (t.visibility !== "visible" || t.display === "none")
		return !1;
	if (cachedElementBoundingRect(e).height)
		return !0;
	var n = document.createRange();
	return n.selectNode(e), !!n.getBoundingClientRect().height
}
function isElementPositionedOffScreen(e) {
	var t = cachedElementBoundingRect(e);
	return !t.height ||!t.width?!1 : t.bottom <= 0 || t.right <= 0?!0 : !1
}
function elementDepth(e) {
	var t = 0;
	while (e)
		e = e.parentElement, t++;
	return t
}
function nearestAncestorElementWithTagName(e, t) {
	while (e = e.parentElement)
		if (e.tagName === t)
			return e;
	return null
}
function cachedElementBoundingRect(e) {
	if (e._cachedElementBoundingRect)
		return e._cachedElementBoundingRect;
	var t = e.getBoundingClientRect();
	return ReaderArticleFinderJS._elementsWithCachedBoundingRects.push(e), !ReaderArticleFinderJS._cachedScrollX&&!ReaderArticleFinderJS._cachedScrollY ? (e._cachedElementBoundingRect = t, e._cachedElementBoundingRect) : (e._cachedElementBoundingRect = {
		top: t.top + ReaderArticleFinderJS._cachedScrollY,
		right: t.right + ReaderArticleFinderJS._cachedScrollX,
		bottom: t.bottom + ReaderArticleFinderJS._cachedScrollY,
		left: t.left + ReaderArticleFinderJS._cachedScrollX,
		width: t.width,
		height: t.height
	}, e._cachedElementBoundingRect)
}
function clearCachedElementBoundingRects() {
	var e = ReaderArticleFinderJS._elementsWithCachedBoundingRects, t = e.length;
	for (var n = 0; n < t; ++n)
		e[n]._cachedElementBoundingRect = null;
	ReaderArticleFinderJS._elementsWithCachedBoundingRects = []
}
function innerTextOrTextContent(e) {
	var t = e.innerText;
	return t || (t = e.textContent), t
}
function levenshteinDistance(e, t) {
	var n = e.length, r = t.length, i = new Array(n + 1);
	for (var s = 0; s < n + 1; ++s)
		i[s] = new Array(r + 1), i[s][0] = s;
	for (var o = 0; o < r + 1; ++o)
		i[0][o] = o;
	for (var o = 1; o < r + 1; ++o)
		for (var s = 1; s < n + 1; ++s)
			if (e[s - 1] === t[o - 1])
				i[s][o] = i[s - 1][o - 1];
			else {
				var u = i[s - 1][o] + 1, a = i[s][o - 1] + 1, f = i[s - 1][o - 1] + 1;
				i[s][o] = Math.min(u, a, f)
			}
	return i[n][r]
}
function stringSimilarity(e, t) {
	var n = Math.max(e.length, t.length);
	return n ? (n - levenshteinDistance(e, t)) / n : 0
}
function stringsAreNearlyIdentical(e, t) {
	return e === t?!0 : stringSimilarity(e, t) > StringSimilarityToDeclareStringsNearlyIdentical
}
function elementIsCommentBlock(e) {
	if (/(^|\s)comment/.test(e.className))
		return !0;
	var t = e.getAttribute("id");
	return t && t.indexOf("comment") === 0?!0 : !1
}
function languageScoreMultiplierForTextNodes(e) {
	if (!e ||!e.length)
		return 1;
	var t = Math.min(e.length, DefaultNumberOfTextNodesToCheckForLanguageMultiplier), n = 0, r = 0;
	for (var i = 0; i < t; i++) {
		var s = e[i].nodeValue.trim(), o = Math.min(s.length, NumberOfCharactersPerTextNodeToEvaluateForLanguageMultiplier);
		for (var u = 0; u < o; u++)
			characterNeedsScoreMultiplier(s[u]) && n++;
		r += o
	}
	return n >= r * MinimumRatioOfCharactersForLanguageMultiplier ? ScoreMultiplierForChineseJapaneseKorean : 1
}
function scoreMultiplierForElementTagNameAndAttributes(e) {
	var t = 1;
	for (var n = e; n; n = n.parentElement) {
		var r = n.getAttribute("id");
		r && (ArticleRegEx.test(r) && (t += ArticleMatchBonus), CommentRegEx.test(r) && (t -= CommentMatchPenalty));
		var i = n.className;
		i && (ArticleRegEx.test(i) && (t += ArticleMatchBonus), CommentRegEx.test(i) && (t -= CommentMatchPenalty)), n.tagName === "ARTICLE" && (t += ArticleMatchBonus)
	}
	return t < 0 ? 0 : t
}
function elementAtPoint(e, t) {
	if (typeof ReaderArticleFinderJSController != "undefined" && ReaderArticleFinderJSController.nodeAtPoint) {
		var n = ReaderArticleFinderJSController.nodeAtPoint(e, t);
		return n && n.nodeType !== Node.ELEMENT_NODE && (n = n.parentElement), n
	}
	return document.elementFromPoint(e, t)
}
function userVisibleURLString(e) {
	return typeof ReaderArticleFinderJSController != "undefined" && ReaderArticleFinderJSController.userVisibleURLString ? ReaderArticleFinderJSController.userVisibleURLString(e) : e
}
function anchorForURL(e, t) {
	var n = t.createElement("a");
	return n.href = e, n
}
function anchorLinksToAttachment(e) {
	return /\battachment\b/i.test(e.getAttribute("rel"))
}
function anchorLinksToTagOrCategoryPage(e) {
	return /\bcategory|tag\b/i.test(e.getAttribute("rel"))
}
function elementsHaveSameTagAndClassNames(e, t) {
	return e.tagName === t.tagName && e.className === t.className
}
function selectorForElement(e) {
	var t = e.tagName, n = e.classList, r = n.length;
	for (var i = 0; i < r; i++)
		t += "." + n[i];
	return t
}
function elementFingerprintForDepth(e, t) {
	function s(e, t) {
		if (!e)
			return "";
		var o = [];
		o.push(selectorForElement(e));
		var u = e.children, a = u.length;
		if (a && t > 0) {
			o.push(n);
			for (var f = 0; f < a; ++f)
				o.push(s(u[f], t - 1)), f !== a - 1 && o.push(i);
			o.push(r)
		}
		return o.join("")
	}
	const n = " / ", r = " \\", i = " | ";
	return s(e, t)
}
function childrenOfParentElement(e) {
	var t = e.parentElement;
	return t ? t.children : []
}
function arrayOfKeysAndValuesOfObjectSortedByValueDescending(e) {
	var t = [];
	for (var n in e)
		e.hasOwnProperty(n) && t.push({
			key: n,
			value: e[n]
		});
	return t.sort(function(e, t) {
		return t.value - e.value
	}), t
}
const ReaderMinimumScore = 1600, ReaderMinimumAdvantage = 15, ArticleMinimumScoreDensity = 4.25, BlacklistedHostsAllowedPathRegexMap = {
	"www.apple.com": /^\/([a-z]{2,4}\/){0,2}pr\/|^\/hotnews\//
}, ListOfHostnameAndTrustedArticleNodeSelectorPairs = [[/.*\.apple.com$/, "article"]], CandidateMinimumWidth = 280, CandidateMinimumHeight = 295, CandidateMinimumArea = 17e4, CandidateMaximumTop = 1300, CandidateMinimumWidthPortionForIndicatorElements = .5, CandidateMinumumListItemLineCount = 4, CandidateTagNamesToIgnore = {
	A: 1,
	EMBED: 1,
	FORM: 1,
	HTML: 1,
	IFRAME: 1,
	OBJECT: 1,
	OL: 1,
	OPTION: 1,
	SCRIPT: 1,
	STYLE: 1,
	svg: 1,
	UL: 1
}, PrependedArticleCandidateMinimumHeight = 50, AppendedArticleCandidateMinimumHeight = 200, AppendedArticleCandidateMaximumVerticalDistanceFromArticle = 150, StylisticClassNames = {
	justfy: 1,
	justify: 1,
	left: 1,
	right: 1,
	small: 1
}, CommentRegEx = /comment|meta|footer|footnote/, CommentMatchPenalty = .75, ArticleRegEx = /(?:(?:^|\s)(?:(post|hentry|entry)[-_]?(?:content|text|body)?|article[-_]?(?:content|text|body|page)?)(?:\s|$))/i, ArticleMatchBonus = .5, DensityExcludedElementSelector = "#disqus_thread, #comments, .userComments", AttributesToRemoveRegEx = /^on|^id$|^class$|^style$/, PositiveRegEx = /article|body|content|entry|hentry|page|pagination|post|text/i, NegativeRegEx = /advertisement|breadcrumb|combx|comment|contact|disqus|footer|link|meta|mod-conversations|promo|related|scroll|share|shoutbox|sidebar|social|sponsor|tags|toolbox|widget/i, VeryPositiveClassNameRegEx = /instapaper_body/, VeryNegativeClassNameRegEx = /instapaper_ignore/, MinimumAverageDistanceBetweenHRElements = 400, MinimumAverageDistanceBetweenHeaderElements = 400, PortionOfCandidateHeightToIgnoreForHeaderCheck = .1, DefaultNumberOfTextNodesToCheckForLanguageMultiplier = 3, NumberOfCharactersPerTextNodeToEvaluateForLanguageMultiplier = 12, MinimumRatioOfCharactersForLanguageMultiplier = .5, ScoreMultiplierForChineseJapaneseKorean = 3, MinimumContentMediaHeight = 150, MinimumContentMediaWidthToArticleWidthRatio = .25, MaximumContentMediaAreaToArticleAreaRatio = .2, LinkContinueMatchRegEx = /continue/gi, LinkNextMatchRegEx = /next/gi, LinkPageMatchRegEx = /page/gi, LinkListItemBonus = 5, LinkPageMatchBonus = 10, LinkNextMatchBonus = 15, LinkContinueMatchBonus = 15, LinkNextOrdinalValueBase = 3, LinkMismatchValueBase = 2, LinkMatchWeight = 200, LinkMaxVerticalDistanceFromArticle = 200, LinkVerticalDistanceFromArticleWeight = 150, LinkCandidateXPathQuery = "descendant-or-self::*[(not(@id) or (@id!='disqus_thread' and @id!='comments')) and (not(@class) or @class!='userComments')]/a", LinkDateRegex = /\D(?:\d\d(?:\d\d)?[\-\/](?:10|11|12|0?[1-9])[\-\/](?:30|31|[12][0-9]|0?[1-9])|\d\d(?:\d\d)?\/(?:10|11|12|0[1-9])|(?:10|11|12|0?[1-9])\-(?:30|31|[12][0-9]|0?[1-9])\-\d\d(?:\d\d)?|(?:30|31|[12][0-9]|0?[1-9])\-(?:10|11|12|0?[1-9])\-\d\d(?:\d\d)?)\D/, LinkURLSearchParameterKeyMatchRegex = /(page|^p$|^pg$)/i, LinkURLPageSlashNumberMatchRegex = /\/.*page.*\/\d+/i, LinkURLSlashDigitEndMatchRegex = /\/\d+\/?$/, LinkURLArchiveSlashDigitEndMatchRegex = /archives?\/\d+\/?$/, LinkURLBadSearchParameterKeyMatchRegex = /author|comment|feed|id|related/i, LinkURLSemanticMatchBonus = 100, LinkMinimumURLSimilarityRatio = .75, HeaderMinimumDistanceFromArticleTop = 200, HeaderLevenshteinDistanceToLengthRatio = .75, FloatMinimumHeight = 130, ImageSizeTiny = 32, ToleranceForLeadingImageWidthToArticleWidthForFullWidthPresentation = 50, MaximumFloatWidth = 325, AnchorImageMinimumWidth = 100, AnchorImageMinimumHeight = 100, MainImageMinimumWidthAndHeight = 83, BaseFontSize = 16, BaseLineHeightRatio = 1.125, MaximumExactIntegralValue = 9007199254740992, TitleCandidateDepthScoreMultiplier = .1, DocumentPositionDisconnected = 1, DocumentPositionPreceding = 2, DocumentPositionFollowing = 4, DocumentPositionContains = 8, DocumentPositionContainedBy = 16, TextNodeLengthPower = 1.25, KnownImageLazyLoadingAttributes = {
	"data-lazy-src": 1,
	"data-original": 1,
	"data-src": 1,
	"original-src": 1,
	"rel:bf_image_src": 1
}, StringSimilarityToDeclareStringsNearlyIdentical = .97;
CandidateElement = function(e, t) {
	this.element = e, this.contentDocument = t, this.textNodes = this.usableTextNodesInElement(this.element), this.rawScore = this.calculateRawScore(), this.tagNameAndAttributesScoreMultiplier = this.calculateElementTagNameAndAttributesScoreMultiplier(), this.languageScoreMultiplier = 0, this.depthInDocument = 0
}, CandidateElement.extraArticleCandidateIfElementIsViable = function(t, n, r, i) {
	const s = "a, b, strong, i, em, u, span";
	var o = cachedElementBoundingRect(t), u = cachedElementBoundingRect(n.element);
	if (i && o.height < PrependedArticleCandidateMinimumHeight ||!i && o.height < AppendedArticleCandidateMinimumHeight)
		if (t.childElementCount && t.querySelectorAll("*").length !== t.querySelectorAll(s).length)
			return null;
	if (i) {
		if (o.bottom > u.top)
			return null
	} else if (o.top < u.bottom)
		return null;
	if (!i) {
		var a = o.top - u.bottom;
		if (a > AppendedArticleCandidateMaximumVerticalDistanceFromArticle)
			return null
	}
	var f = .1 * u.width;
	if (Math.abs(o.left - u.left) > f || Math.abs(o.right - n.right) > f)
		return null;
	var l = new CandidateElement(t, r);
	return l.isPrepended = i, l
}, CandidateElement.candidateIfElementIsViable = function(t, n, r) {
	var i = cachedElementBoundingRect(t);
	return i.width < CandidateMinimumWidth || i.height < CandidateMinimumHeight ? null : i.width * i.height < CandidateMinimumArea ? null : !r && i.top > CandidateMaximumTop ? null : CandidateElement.candidateElementAdjustedHeight(t) < CandidateMinimumHeight ? null : new CandidateElement(t, n)
}, CandidateElement.candidateElementAdjustedHeight = function(t) {
	var n = cachedElementBoundingRect(t), r = n.height, i = t.getElementsByTagName("form"), s = i.length;
	for (var o = 0; o < s; ++o) {
		var u = i[o], a = cachedElementBoundingRect(u);
		a.width > n.width * CandidateMinimumWidthPortionForIndicatorElements && (r -= a.height)
	}
	var f = t.querySelectorAll("ol, ul"), l = f.length, c = null;
	for (var o = 0; o < l; ++o) {
		var h = f[o];
		if (c && c.compareDocumentPosition(h) & DocumentPositionContainedBy)
			continue;
		var p = h.getElementsByTagName("li"), d = p.length, v = cachedElementBoundingRect(h);
		if (!d) {
			r -= v.height;
			continue
		}
		var m = v.height / d, g = getComputedStyle(p[0]), y = parseInt(g.lineHeight);
		if (isNaN(y)) {
			var b = fontSizeFromComputedStyle(g);
			y = b * BaseLineHeightRatio
		}
		v.width > n.width * CandidateMinimumWidthPortionForIndicatorElements && m / y < CandidateMinumumListItemLineCount && (r -= v.height, c = h)
	}
	return r
}, CandidateElement.prototype = {
	calculateRawScore: function() {
		var t = 0, n = this.textNodes, r = n.length;
		for (var i = 0; i < r; ++i)
			t += this.rawScoreForTextNode(n[i]);
		return t
	},
	calculateElementTagNameAndAttributesScoreMultiplier: function() {
		return scoreMultiplierForElementTagNameAndAttributes(this.element)
	},
	calculateLanguageScoreMultiplier: function() {
		if (this.languageScoreMultiplier !== 0)
			return;
		this.languageScoreMultiplier = languageScoreMultiplierForTextNodes(this.textNodes)
	},
	depth: function() {
		return this.depthInDocument || (this.depthInDocument = elementDepth(this.element)), this.depthInDocument
	},
	finalScore: function() {
		return this.calculateLanguageScoreMultiplier(), this.basicScore() * this.languageScoreMultiplier
	},
	basicScore: function() {
		return this.rawScore * this.tagNameAndAttributesScoreMultiplier
	},
	scoreDensity: function() {
		var t = 0, n = this.element.querySelector(DensityExcludedElementSelector);
		n && (t = n.clientWidth * n.clientHeight);
		var r = this.element.children, i = r.length;
		for (var s = 0; s < i; ++s) {
			var o = r[s];
			elementIsCommentBlock(o) && (t += o.clientWidth * o.clientHeight)
		}
		var u = cachedElementBoundingRect(this.element).width * cachedElementBoundingRect(this.element).height, a = u * MaximumContentMediaAreaToArticleAreaRatio, f = cachedElementBoundingRect(this.element).width * MinimumContentMediaWidthToArticleWidthRatio, l = this.element.querySelectorAll("img, object, video"), c = l.length;
		for (var s = 0; s < c; ++s) {
			var h = cachedElementBoundingRect(l[s]);
			if (h.width >= f && h.height > MinimumContentMediaHeight) {
				var p = h.width * h.height;
				p < a && (t += p)
			}
		}
		var d = this.basicScore(), v = u - t, m = this.textNodes.length, g = 0, y = 0;
		for (var s = 0; s < m; ++s) {
			var b = this.textNodes[s].parentNode;
			b && (y += fontSizeFromComputedStyle(getComputedStyle(b)), g++)
		}
		var w = BaseFontSize;
		return g && (w = y/=g), this.calculateLanguageScoreMultiplier(), d / v * 1e3 * (w / BaseFontSize) * this.languageScoreMultiplier
	},
	usableTextNodesInElement: function(t) {
		var n = [];
		if (!t)
			return n;
		const r = {
			A: 1,
			DD: 1,
			DT: 1,
			NOSCRIPT: 1,
			OL: 1,
			OPTION: 1,
			PRE: 1,
			SCRIPT: 1,
			STYLE: 1,
			TD: 1,
			UL: 1,
			IFRAME: 1
		};
		var i = this.contentDocument, s = function(e) {
			const t = "text()|*/text()|*/a/text()|*/li/text()|*/span/text()|*/em/text()|*/i/text()|*/strong/text()|*/b/text()|*/font/text()|blockquote/*/text()|div[count(./p)=count(./*)]/p/text()";
			var s = i.evaluate(t, e, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), o = s.snapshotLength;
			for (var u = 0; u < o; ++u) {
				var a = s.snapshotItem(u);
				if (r[a.parentNode.tagName] || a._countedTextNode || isNodeWhitespace(a))
					continue;
				a._countedTextNode=!0, n.push(a)
			}
		};
		s(t);
		var o = t.childrenWithParallelStructure(), u = o.length;
		for (var a = 0; a < u; ++a) {
			var f = o[a];
			s(f)
		}
		var l = n.length;
		for (var a = 0; a < l; ++a)
			delete n[a]._countedTextNode;
		return n
	},
	addTextNodesFromCandidateElement: function(t) {
		var n = this.textNodes.length;
		for (var r = 0; r < n; ++r)
			this.textNodes[r].alreadyCounted=!0;
		var i = t.textNodes, s = i.length;
		for (var r = 0; r < s; ++r)
			i[r].alreadyCounted || this.textNodes.push(i[r]);
		var n = this.textNodes.length;
		for (var r = 0; r < n; ++r)
			this.textNodes[r].alreadyCounted = null;
		this.rawScore = this.calculateRawScore()
	},
	rawScoreForTextNode: function(t) {
		const n = 20;
		if (!t)
			return 0;
		var r = t.length;
		if (r < n)
			return 0;
		var i = t.parentNode;
		if (!isElementVisible(i))
			return 0;
		var s = 1;
		while (i && i !== this.element)
			s -= .1, i = i.parentNode;
		return Math.pow(r * s, TextNodeLengthPower)
	},
	shouldDisqualifyDueToScoreDensity: function() {
		return this.scoreDensity() < ArticleMinimumScoreDensity?!0 : !1
	},
	shouldDisqualifyDueToHorizontalRuleDensity: function() {
		var t = this.element.getElementsByTagName("hr"), n = t.length, r = 0, i = cachedElementBoundingRect(this.element), s = i.width * .7;
		for (var o = 0; o < n; ++o)
			t[o].clientWidth > s && r++;
		if (r) {
			var u = i.height / r;
			if (u < MinimumAverageDistanceBetweenHRElements)
				return !0
		}
		return !1
	},
	shouldDisqualifyDueToHeaderDensity: function() {
		var t = "(h1|h2|h3|h4|h5|h6|*/h1|*/h2|*/h3|*/h4|*/h5|*/h6)[a[@href]]", n = this.contentDocument.evaluate(t, this.element, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), r = n.snapshotLength;
		if (r > 2) {
			var i = 0, s = cachedElementBoundingRect(this.element), o = s.height * PortionOfCandidateHeightToIgnoreForHeaderCheck;
			for (var u = 0; u < r; ++u) {
				var a = n.snapshotItem(u), f = cachedElementBoundingRect(a);
				f.top - s.top > o && s.bottom - f.bottom > o && i++
			}
			var l = s.height / i;
			if (l < MinimumAverageDistanceBetweenHeaderElements)
				return !0
		}
		return !1
	},
	shouldDisqualifyDueToSimilarElements: function(t) {
		function i(e) {
			return !!{
				H1: 1,
				H2: 1,
				H3: 1,
				H4: 1,
				H5: 1,
				H6: 1
			}
			[e.tagName]
		}
		function s(e, t) {
			if (!e ||!t)
				return !1;
			const n = 1;
			return e.className ? e.className === t.className : elementFingerprintForDepth(e, n) === elementFingerprintForDepth(t, n)
		}
		const n = /clearfix/i, r = "h1, h2, h3, h4, h5, h6";
		var o = this.element;
		if (o.tagName === "LI" || o.tagName === "DD") {
			var u = o.parentNode, a = u.children.length;
			for (var f = 0; f < a; ++f) {
				var l = u.children[f];
				if (l.tagName === o.tagName && l.className === o.className && l !== o)
					return !0
			}
		}
		var c = o.getAttribute("class");
		c || (o = o.parentElement, o && (c = o.getAttribute("class"), c || (o = o.parentElement, o && (c = o.getAttribute("class")))));
		if (c) {
			t || (t = []);
			var h = t.length;
			for (var f = 0; f < h; ++f)
				t[f].element.candidateElement = t[f];
			var p;
			try {
				var d = c.split(" "), v = "";
				for (var f = 0; f < d.length; ++f) {
					if (n.test(d[f]))
						continue;
					d[f].length && (v += "." + d[f])
				}
				p = this.contentDocument.querySelectorAll(v)
			} catch (m) {
				p = []
			}
			var g=!1, y = elementDepth(o), b = p.length;
			for (var f = 0; f < b; ++f) {
				var l = p[f];
				if (l === o)
					continue;
				if (l.parentElement === o || o.parentElement === l)
					continue;
				if (!isElementVisible(l))
					continue;
				var w = l.candidateElement;
				if (!w) {
					w = new CandidateElement(l, this.contentDocument);
					if (!w)
						continue
				}
				if (w.basicScore() * ReaderMinimumAdvantage > this.basicScore()) {
					if (!g && cachedElementBoundingRect(l).bottom < cachedElementBoundingRect(this.element).top) {
						g=!0;
						continue
					}
					if (s(o.previousElementSibling, l.previousElementSibling) || s(o.nextElementSibling, l.nextElementSibling)) {
						var E = o.querySelector(r), S = l.querySelector(r);
						if (E && S && elementsHaveSameTagAndClassNames(E, S))
							return !0;
						E = o.previousElementSibling, S = l.previousElementSibling;
						if (E && S && i(E) && i(S) && elementsHaveSameTagAndClassNames(E, S))
							return !0
					}
					if (elementDepth(l) === y)
						while (l.parentElement && o.parentElement) {
							if (l.parentElement === o.parentElement)
								break;
								l = l.parentElement, o = o.parentElement
						}
					while (o.childElementCount <= 1) {
						if (!o.childElementCount ||!l.childElementCount)
							return !1;
						if (l.childElementCount > 1)
							return !1;
						if (o.firstElementChild.tagName !== l.firstElementChild.tagName)
							return !1;
						o = o.firstElementChild, l = l.firstElementChild
					}
					if (l.childElementCount <= 1)
						return !1;
					var S = l.firstElementChild, x = l.lastElementChild, E = o.firstElementChild, T = o.lastElementChild;
					if (S.tagName !== E.tagName)
						return !1;
					if (x.tagName !== T.tagName)
						return !1;
					var N = S.className, C = x.className, k = E.className, L = x.className, A = L === k ? 2: 1;
					if (N.length || k.length) {
						if (!N.length ||!k.length)
							return !1;
						if (N === k && o.querySelectorAll("." + k.replace(/\s+/, ".")).length <= A)
							return !0
					}
					if (C.length || L.length) {
						if (!C.length ||!L.length)
							return !1;
						if (C === L && o.querySelectorAll("." + L.replace(/\s+/, ".")).length <= A)
							return !0
					}
					var O = E.clientHeight, M = T.clientHeight;
					return !O ||!S.clientHeight?!1 : !M ||!x.clientHeight?!1 : O === S.clientHeight || M === x.clientHeight?!0 : !1
				}
			}
			for (var f = 0; f < h; ++f)
				t[f].element.candidateElement = null
		}
		return !1
	},
	shouldDisqualifyForDeepLinking: function() {
		function n(e) {
			var t = e.pathname.substring(1).split("/");
			return t[t.length - 1] || t.pop(), t
		}
		const t = 5;
		var r = this.element, i = this.contentDocument.location, s = n(i), o = s.length, u = [], a = r.getElementsByTagName("a"), f = a.length;
		for (var l = 0; l < f; l++) {
			var c = a[l];
			if (i.host !== c.host)
				continue;
			if (n(c).length <= o)
				continue;
			if ((c.host + c.pathname).indexOf(i.host + i.pathname) !== 0)
				continue;
			if (anchorLinksToAttachment(c))
				continue;
			u.push(c);
			if (u.length < t)
				continue;
			var h = r.offsetTop + r.offsetHeight / t;
			return u[0].offsetTop < h
		}
		return !1
	}
}, String.prototype.lastInteger = function() {
	const t = /[0-9]+/g;
	var n = this.match(t);
	return n ? parseInt(n[n.length - 1]) : NaN
}, String.prototype.escapeCharacters = function(e) {
	var t=!1, n = e.length;
	for (var r = 0; r < n; ++r)
		if (this.indexOf(e.charAt(r))!==-1) {
			t=!0;
			break
		}
	if (!t)
		return this;
	var i = "", s = this.length;
	for (var r = 0; r < s; ++r)
		e.indexOf(this.charAt(r))!==-1 && (i += "\\"), i += this.charAt(r);
	return i
}, String.prototype.escapeForRegExp = function() {
	return this.escapeCharacters("^[]{}()\\.$*+?|")
}, Element.prototype.childrenWithParallelStructure = function() {
	var e = this.children;
	if (!e)
		return [];
	var t = e.length;
	if (!t)
		return [];
	var n = {};
	for (var r = 0; r < t; ++r) {
		var i = e[r];
		if (CandidateTagNamesToIgnore[i.tagName] ||!i.className)
			continue;
		var s = i.classList, o = s.length;
		for (var u = 0; u < o; ++u) {
			var a = s[u], f = n[a];
			f ? f.push(i) : n[a] = [i]
		}
	}
	var l = Math.floor(t / 2);
	for (var a in n) {
		var f = n[a];
		if (f.length > l)
			return f
	}
	return []
}, ReaderArticleFinder = function(e) {
	this.contentDocument = e, this.didSearchForArticleNode=!1, this.article = null, this.didSearchForExtraArticleNode=!1, this.extraArticle = null, this.leadingImage = null, this._cachedScrollY = 0, this._cachedScrollX = 0, this._elementsWithCachedBoundingRects = [], this._cachedContentTextStyle = null, this.pageNumber = 1, this.prefixWithDateForNextPageURL = null, this._elementsEvaluatedForTextContent = [], this.previouslyDiscoveredPageURLStrings = []
}, ReaderArticleFinder.prototype = {
	isReaderModeAvailable: function() {
		return this.canRunReaderDetection() ? this.findArticleBySearchingWhitelist()?!0 : (this.cacheWindowScrollPosition(), this.article = this.findArticleByVisualExamination(), this.article && this.articleIsLTR(), !!this.article) : null
	},
	prepareToTransitionToReader: function() {
		this.adoptableArticle(!0), this.nextPageURL(), this.articleIsLTR()
	},
	nextPageURL: function() {
		if (!this._nextPageURL) {
			var t = this.nextPageURLString();
			typeof ReaderArticleFinderJSController != "undefined" && t && (t = ReaderArticleFinderJSController.substituteURLForNextPageURL(t)), this._nextPageURL = t
		}
		return this._nextPageURL
	},
	containerElementsForMultiPageContent: function() {
		const e = /(.*page.*)(\d{1,2})(.*)/i, t = 3;
		var n = [], r = this.articleNode(), i, s = 0;
		for (; ;) {
			i = e.exec(r.getAttribute("id"));
			if (i)
				break;
			r = r.parentElement;
			if (!r || s++===t)
				return []
		}
		var o = childrenOfParentElement(r), u = o.length;
		for (var a = 0; a < u; ++a) {
			var f = o[a];
			if (f === r)
				continue;
			var l = e.exec(f.getAttribute("id"));
			if (!l || l[1] !== i[1] || l[3] !== i[3])
				continue;
			if (isElementVisible(f)&&!isElementPositionedOffScreen(f))
				continue;
			n.push(f)
		}
		return n
	},
	adoptableMultiPageContentElements: function() {
		return this.containerElementsForMultiPageContent().map(function(e) {
			return this.cleanArticleNode(e, e.cloneNode(!0), !1)
		}, this)
	},
	classNameIsSignificantInRouteComputation: function(t) {
		return t?!(t.toLowerCase()in StylisticClassNames) : !1
	},
	shouldIgnoreInRouteComputation: function(t) {
		return t.tagName === "SCRIPT" || t.tagName === "LINK" || t.tagName === "STYLE"?!0 : t.tagName !== "TR"?!1 : t.offsetHeight?!1 : !0
	},
	routeToArticleNode: function() {
		var t = [], n = this.articleNode();
		while (n) {
			var r = {};
			r.tagName = n.tagName;
			var i = n.getAttribute("id");
			i && (r.id = i), this.classNameIsSignificantInRouteComputation(n.className) && (r.className = n.className), r.index = 1;
			for (var s = n.previousElementSibling; s; s = s.previousElementSibling)
				this.shouldIgnoreInRouteComputation(s) || r.index++;
			t.unshift(r), n = n.parentElement
		}
		return t
	},
	adjustArticleNode: function(t) {
		if (!this.article)
			return;
		var n = this.article.element;
		while (n = n.parentElement)
			if (VeryPositiveClassNameRegEx.test(n.className)) {
				this.article.element = n;
				return
			}
		n = this.article.element;
		if (n.getAttribute("id") ||!n.className)
			return;
		var r = n.tagName, i = n.className, s = n.parentElement, o = s.children;
		for (var u = 0, a = o.length; u < a; ++u) {
			var f = o[u];
			if (f === n)
				continue;
			if (f.tagName !== r || f.className !== i)
				continue;
			var l = CandidateElement.candidateIfElementIsViable(f, this.contentDocument, !0);
			if (!l || l.finalScore() < ReaderMinimumScore)
				continue;
			this.article.element = s;
			return
		}
	},
	findArticleBySearchingWhitelist: function() {
		var t = ListOfHostnameAndTrustedArticleNodeSelectorPairs.length;
		for (var n = 0; n < t; ++n) {
			var r = ListOfHostnameAndTrustedArticleNodeSelectorPairs[n], i = r[0];
			if (!i.test(this.contentDocument.location.hostname))
				continue;
			var s = r[1], o = this.contentDocument.querySelectorAll(s);
			if (o.length === 1)
				return new CandidateElement(o[0], this.contentDocument)
		}
		return null
	},
	articleNode: function(t) {
		return this.didSearchForArticleNode || (this.article = this.findArticleBySearchingWhitelist(), this.article || (this.article = this.findArticleBySearchingAllElements()), this.article || (this.article = this.findArticleByVisualExamination()), !this.article && t && (this.article = this.findArticleBySearchingAllElements(!0)), this.didSearchForArticleNode=!0, this.article && this.articleIsLTR()), this.adjustArticleNode(), this.article ? this.article.element : null
	},
	extraArticleNode: function() {
		return this.didSearchForArticleNode || this.articleNode(), this.didSearchForExtraArticleNode || (this.extraArticle = this.findExtraArticle(), this.didSearchForExtraArticleNode=!0), this.extraArticle ? this.extraArticle.element : null
	},
	cacheWindowScrollPosition: function() {
		this._cachedScrollY = window.scrollY, this._cachedScrollX = window.scrollX
	},
	contentTextStyle: function() {
		return this._cachedContentTextStyle ? this._cachedContentTextStyle : (this._cachedContentTextStyle = contentTextStyleForNode(this.contentDocument, this.articleNode()), this._cachedContentTextStyle || (this._cachedContentTextStyle = getComputedStyle(this.articleNode())), this._cachedContentTextStyle)
	},
	commaCountIsLessThan: function(t, n) {
		var r = 0, i = t.textContent, s =- 1;
		while (r < n && (s = i.indexOf(",", s + 1)) >= 0)
			r++;
		return r < n
	},
	calculateLinkDensity: function(t) {
		var n = removeWhitespace(t.textContent).length;
		if (!n)
			return 0;
		var r = t.getElementsByTagName("a"), i = 0, s = r.length;
		for (var o = 0; o < s; ++o)
			i += removeWhitespace(r[o].textContent).length;
		return i / n
	},
	shouldPruneElement: function(t, n) {
		const r = .33, i = .5, s = .2, o = 25, u = 4e4, a = /youtube|vimeo|dailymotion/;
		if (!t.parentElement)
			return !1;
		if (t.tagName === "IFRAME")
			return !a.test(anchorForURL(t.src, this.contentDocument).hostname);
		if (t.tagName !== "OBJECT" && t.tagName !== "EMBED" && t.tagName !== "CANVAS") {
			var f=!1, l = t.childNodes.length;
			for (var c = 0; c < l; ++c) {
				var h = t.childNodes[c], p = h.nodeType;
				if (p === Node.ELEMENT_NODE || p === Node.TEXT_NODE&&!isNodeWhitespace(h)) {
					f=!0;
					break
				}
			}
			if (!f) {
				if (t.tagName === "P") {
					var d = t.previousSibling, v = t.nextSibling;
					if (d && d.nodeType === Node.TEXT_NODE&&!isNodeWhitespace(d) && v && v.nodeType === Node.TEXT_NODE&&!isNodeWhitespace(v))
						return !1
				}
				return !0
			}
			if (t.tagName === "P")
				return !1
		}
		if (t.tagName === "CANVAS")
			return t.parentNode.tagName === "CUFON";
		var m = 0;
		if (n) {
			if (VeryNegativeClassNameRegEx.test(n.className))
				return !0;
			var g = n.className, y = n.getAttribute("id");
			PositiveRegEx.test(g) && m++, PositiveRegEx.test(y) && m++, NegativeRegEx.test(g) && m--, NegativeRegEx.test(y) && m--
		}
		if (m < 0)
			return !0;
		if (t.tagName === "UL")
			return n.querySelector("iframe") && n.querySelector("script")?!0 : !1;
		if (t.tagName === "OBJECT") {
			var b = t.querySelector("embed[src]"), w = b ? anchorForURL(b.src, this.contentDocument): null;
			if (w && a.test(w.hostname))
				return !1;
			var E = t.getAttribute("data");
			return w = E ? anchorForURL(E, this.contentDocument) : null, w && a.test(w.hostname)?!1 : !0
		}
		if (t.childElementCount === 1) {
			var S = t.firstElementChild;
			if (S.tagName === "A")
				return !1;
			if (S.tagName === "SPAN" && S.className === "converted-anchor" && nearestAncestorElementWithTagName(S, "TABLE"))
				return !1
		}
		var x = t.getElementsByTagName("img"), T = x.length;
		if (T) {
			var N = 0;
			for (var c = 0; c < T; ++c) {
				var C = x[c].originalElement;
				if (!isElementVisible(C))
					continue;
				var k = cachedElementBoundingRect(C);
				N += k.width / T * (k.height / T)
			}
			if (N > u)
				return !1
		}
		if (!this.commaCountIsLessThan(t, 10))
			return !1;
		var L = t.getElementsByTagName("p").length, A = t.getElementsByTagName("br").length, O = L + Math.floor(A / 2);
		if (T > O)
			return !0;
		if (t.getElementsByTagName("li").length > O)
			return !0;
		if (t.getElementsByTagName("input").length / O > r)
			return !0;
		if (t.textContent.length < o && T !== 1)
			return !0;
		if (t.querySelector("embed"))
			return !0;
		var M = this.calculateLinkDensity(t);
		if (m >= 1 && M > i)
			return !0;
		if (m < 1 && M > s)
			return !0;
		if (t.tagName === "TABLE") {
			var _ = removeWhitespace(t.innerText).length, D = removeWhitespace(n.innerText).length;
			if (_ <= D * .5)
				return !0
		}
		return !1
	},
	wordCountIsLessThan: function(t, n) {
		var r = 0, i = t.textContent, s =- 1;
		while ((s = i.indexOf(" ", s + 1)) >= 0 && r < n)
			r++;
		return r < n
	},
	leadingImageIsAppropriateWidth: function(t) {
		return !this.article ||!t?!1 : t.getBoundingClientRect().width >= this.article.element.getBoundingClientRect().width - ToleranceForLeadingImageWidthToArticleWidthForFullWidthPresentation
	},
	newDivFromNode: function(t) {
		var n = this.contentDocument.createElement("div");
		return t && (n.innerHTML = t.innerHTML), n
	},
	adoptableLeadingImage: function() {
		const t = 5, n = /credit/, r = /caption/, i = /src|alt/;
		if (!this.article ||!this.leadingImage ||!this.leadingImageIsAppropriateWidth(this.leadingImage))
			return null;
		var s = this.leadingImage.parentNode, o = null, u = null, a = s.children.length;
		if (s.tagName === "DIV" && a > 1 && a < t) {
			var f = s.cloneNode(!0).querySelectorAll("p, div"), l = f.length;
			for (var c = 0; c < l; ++c) {
				var h = f[c];
				n.test(h.className) ? o = h.cloneNode(!0) : r.test(h.className) && (u = h.cloneNode(!0))
			}
		}
		var p = this.leadingImage.cloneNode(!1), d = p.attributes;
		for (var c = 0; c < d.length; ++c) {
			var v = d[c].nodeName;
			i.test(v) || (p.removeAttribute(v), c--)
		}
		var m = this.contentDocument.createElement("div");
		m.className = "leading-image", m.appendChild(p);
		if (o) {
			var g = this.newDivFromNode(o);
			g.className = "credit", m.appendChild(g)
		}
		if (u) {
			var y = this.newDivFromNode(u);
			y.className = "caption", m.appendChild(y)
		}
		return m
	},
	adoptableArticle: function(t) {
		if (this._adoptableArticle)
			return this._adoptableArticle.cloneNode(!0);
		clearCachedElementBoundingRects(), this.cacheWindowScrollPosition();
		var n = this.articleNode(t);
		this._adoptableArticle = n ? n.cloneNode(!0) : null;
		if (!this._adoptableArticle)
			return this._adoptableArticle;
		this._articleBoundingRect = cachedElementBoundingRect(this.article.element), this._adoptableArticle = this.cleanArticleNode(n, this._adoptableArticle, !1);
		if (this._adoptableArticle.tagName === "P") {
			var r = document.createElement("div");
			r.appendChild(this._adoptableArticle), this._adoptableArticle = r
		}
		var i = this.extraArticleNode();
		if (i) {
			var s = this.cleanArticleNode(i, i.cloneNode(!0), !0);
			s && (this.extraArticle.isPrepended ? this._adoptableArticle.insertBefore(s, this._adoptableArticle.firstChild) : this._adoptableArticle.appendChild(s));
			var o = cachedElementBoundingRect(this.article.element), u = cachedElementBoundingRect(this.extraArticle.element), a = {
				top: Math.min(o.top, u.top),
				right: Math.max(o.right, u.right),
				bottom: Math.max(o.bottom, u.bottom),
				left: Math.min(o.left, u.left)
			};
			a.width = a.right - a.left, a.height = a.bottom - a.top, this._articleBoundingRect = a
		}
		this._articleTextContent = this._adoptableArticle.innerText;
		var f = this.adoptableLeadingImage();
		return f && this._adoptableArticle.insertBefore(f, this._adoptableArticle.firstChild), this._adoptableArticle
	},
	elementPinToEdge: function(t) {
		const n = {
			AREA: 1,
			BR: 1,
			CANVAS: 1,
			EMBED: 1,
			FRAME: 1,
			HR: 1,
			IMG: 1,
			INPUT: 1
		}, r = 120;
		if (window.scrollY < r)
			return null;
		var i = cachedElementBoundingRect(t), s = t.ownerDocument.elementFromPoint((i.left + i.right) / 2, 0);
		s && s.tagName in n && (s = s.parentElement);
		var o = s;
		while (o && o !== t)
			o = o.parentNode;
		return o ? s : null
	},
	dominantContentUnitSelector: function(e) {
		var t = e.children, n = t.length, r = {};
		for (var i = 0; i < n; ++i) {
			var s = t[i];
			if (!isElementVisible(s))
				continue;
			var o = selectorForElement(s);
			r[o] ? r[o] += 1 : r[o] = 1
		}
		var u = arrayOfKeysAndValuesOfObjectSortedByValueDescending(r);
		switch (u.length) {
		case 0:
			return null;
		case 1:
			return u[0].key;
		default:
			var a = u[0];
			return a.value > u[1].value ? a.key : null
		}
	},
	cleanArticleNode: function(t, n, r) {
		function S(e) {
			f += e, l && (l += e), c && (c += e), h && (h += e), p && (p += e)
		}
		function x() {
			l === 1 && (l = 0), c === 1 && (c = 0), h === 1 && (h = 0), p === 1 && (p = 0)
		}
		function T() {
			const e = .8;
			var n = cachedElementBoundingRect(t);
			if (n.width === 0 || n.height === 0)
				return !0;
			var r = t.childrenWithParallelStructure(), i = r.length, s;
			if (i) {
				s = [];
				for (var o = 0; o < i; ++o) {
					var u = r[o];
					if (getComputedStyle(u).float === "none") {
						var a = u.children, f = a.length;
						for (var l = 0; l < f; ++l)
							s.push(a[l])
						} else
							s.push(u)
						}
			} else
				s = t.children;
			var c = s.length, h = 0;
			for (var o = 0; o < c; ++o) {
				var p = s[o];
				getComputedStyle(p).float !== "none" && (h += p.innerText.length)
			}
			var d = t.innerText.length, v = h / d;
			return v > e
		}
		function N(e) {
			const n = 50;
			if (cachedElementBoundingRect(e).height > n)
				return !1;
			const r = {
				UL: 1,
				LI: 1,
				NAV: 1
			};
			return r[e.tagName]?!0 : e.parentElement === t&&!e.nextElementSibling?!0 : !1
		}
		const i = {
			FORM: 1,
			SCRIPT: 1,
			STYLE: 1,
			LINK: 1
		}, s = {
			DIV: 1,
			TABLE: 1,
			OBJECT: 1,
			UL: 1,
			CANVAS: 1,
			P: 1,
			IFRAME: 1,
			ASIDE: 1
		}, o = {
			I: 1,
			EM: 1
		}, u = {
			B: 1,
			STRONG: 1,
			H1: 1,
			H2: 1,
			H3: 1,
			H4: 1,
			H5: 1,
			H6: 1
		};
		var a = [], f = 0, l = 0, c = 0, h = 0, p = 0, d = t, v = d.ownerDocument.defaultView, m = n, g = this.articleTitle(), y = this._articleTitleElement, b = this.elementPinToEdge(t), w = null, E = isElementVisible(t), C = this.dominantContentUnitSelector(t), k = T(), L = new Set;
		this.previouslyDiscoveredPageURLStrings.forEach(function(e) {
			L.add(e)
		});
		var A = this.nextPageURL();
		A && L.add(A);
		while (d) {
			var O = null, M = m.tagName;
			m.originalElement = d, d === b && (w = m), M in i && (O = m), !O && d === y && (O = m);
			if (!O && (M === "H1" || M === "H2")) {
				var _ = d.offsetTop - t.offsetTop;
				if (_ < HeaderMinimumDistanceFromArticleTop) {
					var D = innerTextOrTextContent(d), P = D.length * HeaderLevenshteinDistanceToLengthRatio;
					levenshteinDistance(g, D) <= P && (O = m)
				}
			}
			O || this.isMediaWikiPage() && /editsection/.test(d.className) && (O = m);
			var H;
			O || (H = getComputedStyle(d));
			if (!O && M === "DIV" && m.parentNode) {
				var B = d.querySelectorAll("a, blockquote, dl, div, img, ol, p, pre, table, ul"), j = l || H["float"] !== "none";
				if (!j&&!B.length) {
					var F = m.parentNode, I = this.contentDocument.createElement("p");
					while (m.firstChild) {
						var q = m.firstChild;
						I.appendChild(q)
					}
					F.replaceChild(I, m), w === m && (w = I), m = I, m.originalElement = d, M = m.tagName
				}
			}
			!O && m.parentNode && M in s && a.push(m);
			if (!O) {
				if (E) {
					var R = H.display === "none" || H.visibility !== "visible";
					if (R) {
						var U = C ? f === 1 && selectorForElement(d) === C: !1;
						U || (O = m)
					}
				}
				isElementPositionedOffScreen(d) ? O = m : d !== t&&!l && H["float"] !== "none"&&!k && (cachedElementBoundingRect(d).height >= FloatMinimumHeight || d.childElementCount > 1) && (l = 1)
			}
			if (!O) {
				var z = m.attributes;
				for (var W = 0; W < z.length; ++W) {
					var X = z[W].nodeName;
					AttributesToRemoveRegEx.test(X) && (m.removeAttribute(X), W--)
				}
				H.clear === "both" && m.classList.add("clear");
				if ((M === "UL" || M === "OL") && H["list-style-type"] === "none" && H["background-image"] === "none") {
					var V = d.children, $ = V.length, J=!0;
					for (var W = 0; W < $; ++W) {
						var K = getComputedStyle(V[W]);
						if (K["list-style-type"] !== "none" || parseInt(K["-webkit-padding-start"]) !== 0) {
							J=!1;
							break
						}
					}
					J && m.classList.add("list-style-type-none")
				}
				!h && H.fontStyle !== "normal" && (M in o || (m.style.fontStyle = H.fontStyle), h = 1), !p && H.fontWeight !== "normal" && (M in u || (m.style.fontWeight = H.fontWeight), p = 1);
				if (l) {
					l === 1 && (cachedElementBoundingRect(d).width <= MaximumFloatWidth ? m.setAttribute("class", "auxiliary float " + H["float"]) : m.classList.add("auxiliary"));
					var Q = d.style.getPropertyValue("width");
					if (Q)
						m.style.width = Q;
					else {
						var G = v.getMatchedCSSRules(d, "", !0);
						if (G) {
							var Y = G.length;
							for (var W = Y - 1; W >= 0; --W) {
								Q = G[W].style.getPropertyValue("width");
								if (Q) {
									m.style.width = Q;
									break
								}
							}
						}
					}
					l === 1&&!Q && (m.style.width = cachedElementBoundingRect(d).width + "px");
					var Z = m.parentNode === n ? 36: 12, et = m.style.width;
					et && parseInt(et) >= screen.width - Z && m.setAttribute("class", "large-element")
				}
				if (M === "TABLE")
					c || (c = 1);
				else if (M === "VIDEO") {
					var tt = cachedElementBoundingRect(d);
					const nt = 36;
					tt.width > screen.width - nt && m.setAttribute("class", "large-element")
				} else if (M === "IMG") {
					var rt=!1;
					if (m.naturalWidth === 1 && m.naturalHeight === 1) {
						var it = z.length;
						for (var W = 0; W < it; ++W) {
							var X = z[W].nodeName;
							if (KnownImageLazyLoadingAttributes[X.toLowerCase()]) {
								m.setAttribute("src", m.getAttribute(X)), rt=!0;
								break
							}
						}
					}
					m.removeAttribute("border"), m.removeAttribute("hspace"), m.removeAttribute("vspace");
					var st = m.getAttribute("align");
					m.removeAttribute("align");
					if (st === "left" || st === "right")
						m.classList.add("float"), m.classList.add(st);
					if (!l&&!rt) {
						var ot = cachedElementBoundingRect(d), ut = ot.width, at = ot.height;
						ut === 1 && at === 1 ? O = m : ut < ImageSizeTiny && at < ImageSizeTiny && m.setAttribute("class", "reader-image-tiny")
					}
				} else if (M === "FONT")
					m.removeAttribute("size"), m.removeAttribute("face"), m.removeAttribute("color");
				else if (M === "A" && m.parentNode) {
					var ft = m.getAttribute("href");
					if (ft && ft.length && (ft[0] === "#" || ft.substring(0, 11) === "javascript:")) {
						if (!c&&!m.childElementCount && m.parentElement.childElementCount === 1 && m.parentElement.tagName !== "LI") {
							var lt = this.contentDocument.evaluate("text()", m.parentElement, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
							lt.snapshotLength || (O = m)
						}
						if (!O) {
							var I = this.contentDocument.createElement("span");
							if (m.childElementCount === 1 && m.firstElementChild.tagName === "IMG") {
								var ct = m.firstElementChild;
								ct.width > AnchorImageMinimumWidth && ct.height > AnchorImageMinimumHeight && I.setAttribute("class", "converted-image-anchor")
							}
							I.className || I.setAttribute("class", "converted-anchor");
							while (m.firstChild)
								I.appendChild(m.firstChild);
							m.parentNode.replaceChild(I, m), m = I, w === m && (w = I)
						}
					}
				}
			}
			!O && elementIsCommentBlock(d) && (O = m);
			if (!O && M === "A" && L.has(d.href)) {
				var ht = d, pt = m, dt, vt;
				while ((ht = ht.parentElement) && (pt = pt.parentElement)) {
					const mt = 10;
					if (cachedElementBoundingRect(ht).top - cachedElementBoundingRect(d).top > mt)
						break;
					if (ht === t)
						break;
					N(ht) && (dt = ht, vt = pt)
				}
				dt && (O = vt, d = dt, m = vt, m.originalElement = d, M = m.tagName), ht = null, pt = null, dt = null, vt = null
			}
			var gt = O ? null: d.firstElementChild;
			if (gt)
				d = gt, m = m.firstElementChild, S(1);
			else {
				var yt;
				while (d !== t&&!(yt = d.nextElementSibling))
					d = d.parentElement, m = m.parentElement, S( - 1);
				if (d === t) {
					if (O)
						if (O.parentElement)
							O.remove();
						else if (r)
							return null;
					break
				}
				d = yt, m = m.nextElementSibling, x()
			}
			if (O)
				if (O.parentElement)
					O.remove();
				else if (r)
					return null
		}
		for (var W = a.length - 1; W >= 0; --W) {
			var bt = a[W];
			bt.parentNode && this.shouldPruneElement(bt, bt.originalElement) && (w === bt && ((w = bt.nextElementSibling) || (w = bt.parentElement)), bt.remove())
		}
		var wt = n.querySelectorAll(".float");
		for (var W = 0; W < wt.length; ++W) {
			var Et=!1, St = wt[W];
			if (!Et) {
				var xt = St.querySelectorAll("a, span.converted-image-anchor"), Tt = St.querySelectorAll("span.converted-anchor");
				Et = St.parentNode && Tt.length > xt.length
			}
			if (!Et) {
				var Nt = St.querySelectorAll("embed, object").length, Ct = St.originalElement.querySelectorAll("embed, object").length;
				!Nt && Ct && (Et=!0)
			}
			if (!Et) {
				var kt = St.originalElement.getElementsByTagName("img"), Lt = kt.length, At = 0;
				for (var Ot = 0; Ot < Lt; ++Ot) {
					E && isElementVisible(kt[Ot]) && At++;
					if (At > 1)
						break
				}
				if (At === 1) {
					var Mt = St.getElementsByTagName("img").length;
					Mt || (Et=!0)
				}
			}
			Et && (w === St && ((w = St.nextElementSibling) || (w = St.parentElement)), St.remove())
		}
		if (r&&!removeWhitespace(n.innerText).length)
			return null;
		if (w) {
			var _t = document.createElement("div"), Dt = w.originalElement.getBoundingClientRect(), Pt = Dt.height > 0 ? Dt.top * 100 / Dt.height: 0;
			_t.style.position = "relative", _t.style.top = Math.round( - Pt) + "%", _t.setAttribute("id", "safari-reader-element-marker"), w.insertBefore(_t, w.firstChild)
		}
		return n
	},
	leadingImageNode: function() {
		const t = 250, n = .5, r = 3;
		if (!this.article ||!this.article.element)
			return null;
		var i = this.article.element;
		for (var s = 0; s < r; ++s) {
			if (!i.parentNode)
				break;
			i = i.parentNode;
			var o = i.getElementsByTagName("img")[0];
			if (o) {
				var u = cachedElementBoundingRect(o);
				if (u.height >= t && u.width >= this._articleWidth * n) {
					var a = this.article.element.compareDocumentPosition(o);
					if (!(a & DocumentPositionPreceding) || a & DocumentPositionContainedBy)
						continue;
					a = this.extraArticle ? this.extraArticle.element.compareDocumentPosition(o) : null;
					if (a && (!(a & DocumentPositionPreceding) || a & DocumentPositionContainedBy))
						continue;
					return o
				}
			}
		}
		return null
	},
	mainImageNode: function() {
		var t = this.leadingImageNode();
		if (t)
			return t;
		if (this.article && this.article.element) {
			var n = this.article.element.querySelectorAll("img"), r = n.length;
			for (var i = 0; i < r; ++i) {
				var s = n[i], o = s._cachedElementBoundingRect;
				o || (o = s.getBoundingClientRect());
				if (o.width >= MainImageMinimumWidthAndHeight && o.height >= MainImageMinimumWidthAndHeight)
					return s
			}
		}
		return null
	},
	articleTitle: function() {
		function m(e, t) {
			var n = e ? t.indexOf(e): - 1;
			return n!==-1 && (n === 0 || n + e.length === t.length)
		}
		function g(e, t) {
			return e.host === t.host && e.pathname === t.pathname
		}
		if (!this.articleNode())
			return;
		if (this._articleTitle)
			return this._articleTitle;
		const t = 500, n = 20, r = 8, i = 1.1, s = 1.25, o = /header|title|headline|instapaper_title/i, u = 1.5, a = 1.8, f = 1.5, l = .6, c = 3, h = 1.5, p = 9, d = 1.5, v = /byline|author/i;
		var y = this.contentDocument.title, b = this.contentDocument.querySelector("head meta[property='og:title']"), w = b && b.attributes.length === 2 ? b.content: null, E = cachedElementBoundingRect(this.articleNode());
		this.extraArticleNode() && this.extraArticle.isPrepended && (E = cachedElementBoundingRect(this.extraArticleNode()));
		var S = E.left + E.width / 2, x = E.top, T = x;
		this._articleWidth = E.width, this.leadingImage = this.leadingImageNode();
		if (this.leadingImage) {
			var N = cachedElementBoundingRect(this.leadingImage);
			T = (N.top + x) / 2
		}
		var C = "h1, h2, h3, h4, h5, .headline, .article_title, #hn-headline, .inside-head, .instapaper_title", k = this.article.element.tagName;
		if (k === "DL" || k === "DD")
			C += ", dt";
		var L = this.contentDocument.querySelectorAll(C);
		L = Array.prototype.slice.call(L, 0);
		var A = this.contentDocument.location, O = this.article.element.getElementsByTagName("a");
		for (var M = 0; M < O.length; M++) {
			var _ = O[M];
			if (_.offsetTop > this.articleNode().offsetTop + n)
				break;
			if (g(_, A)) {
				L.push(_);
				break
			}
		}
		var D, P = L.map(innerTextOrTextContent), H = L.length, B = 0, j = [], F = [];
		for (var M = 0; M < H; ++M) {
			var I = P[M], q = stringSimilarity(y, I);
			if (w) {
				var R = stringSimilarity(w, I);
				q += R, R > StringSimilarityToDeclareStringsNearlyIdentical && F.push(L[M])
			}
			q === B ? j.push(L[M]) : q > B && (B = q, j = [L[M]])
		}
		F.length === 1 && (D = F[0], D.headerText = innerTextOrTextContent(D));
		if (!D)
			for (var M = 0; M < H; ++M) {
				var U = L[M];
				if (!isElementVisible(U))
					continue;
					var z = cachedElementBoundingRect(U), W = z.left + z.width / 2, X = z.top + z.height / 2, V = W - S, $ = X - T, J = F.indexOf(U)!==-1, K = J, Q = Math.sqrt(V * V + $ * $), G = K ? t: Math.max(t - Q, 0), I = P[M], Y = U.getAttribute("property");
					if (Y) {
						var Z = /dc.title/i.exec(Y);
						if (Z && Z[0]) {
							var et = this.contentDocument.querySelectorAll('*[property~="' + Z[0] + '"]');
							if (et.length === 1) {
								D = U, D.headerText = I;
								break
							}
						}
					}
					if (v.test(U.className))
						continue;
						if (!K) {
							if (Q > t)
								continue;
								if (W < E.left || W > E.right)
									continue
						}
						if (y && stringsAreNearlyIdentical(I, y))
							G*=c;
						else if (m(I, y))
							G*=h;
						else if (I.length < r)
							continue;
							var tt=!1, nt = nearestAncestorElementWithTagName(U, "A");
							nt || (nt = U.querySelector("a"));
							if (nt) {
								var rt = nt.host === A.host, it = nt.pathname === A.pathname;
								if (rt && it)
									G*=f;
								else {
									if (rt && nearestAncestorElementWithTagName(U, "LI"))
										continue;
										G*=l, tt=!0
								}
							}
							var st = fontSizeFromComputedStyle(getComputedStyle(U));
							tt || (G*=st / BaseFontSize), G*=1 + TitleCandidateDepthScoreMultiplier * elementDepth(U);
							var ot = parseInt(this.contentTextStyle().fontSize);
							parseInt(st) > ot * i && (G*=s);
							if (o.test(U.className) || o.test(U.getAttribute("id")))
								G*=u;
								var ut = U.parentElement;
								ut && (o.test(ut.className) || o.test(ut.getAttribute("id"))) && (G*=u), j.indexOf(U)!==-1 && (G*=a);
								if (!D || G > D.headerScore)
									D = U, D.headerScore = G, D.headerText = I
			}
		D && domDistance(D, this.articleNode(), p + 1) > p && parseInt(getComputedStyle(D).fontSize) < d * ot && (D = null);
		if (D) {
			this._articleTitleElement = D;
			var at = D.headerText.trim();
			w && m(w, at) ? this._articleTitle = w : y && m(y, at) ? this._articleTitle = y : this._articleTitle = at
		}
		return this._articleTitle || (w && m(w, y) ? this._articleTitle = w : this._articleTitle = y), this._articleTitle
	},
	articleIsLTR: function() {
		if (!this._articleIsLTR) {
			var t = getComputedStyle(this.article.element);
			this._articleIsLTR = t ? t.direction === "ltr" : !0
		}
		return this._articleIsLTR
	},
	findSuggestedCandidate: function() {
		var t = this.suggestedRouteToArticle;
		if (!t ||!t.length)
			return null;
		var n, r;
		for (r = t.length - 1; r >= 0; --r)
			if (t[r].id) {
				n = this.contentDocument.getElementById(t[r].id);
				if (n)
					break
			}
		r++, n || (n = this.contentDocument);
		while (r < t.length) {
			var i = t[r], s = n.nodeType === Node.DOCUMENT_NODE ? n.documentElement: n.firstElementChild;
			for (var o = 1; s && o < i.index; s = s.nextElementSibling)
				this.shouldIgnoreInRouteComputation(s) || o++;
			if (!s)
				return null;
			if (s.tagName !== i.tagName)
				return null;
			if (i.className && s.className !== i.className)
				return null;
			n = s, r++
		}
		return isElementVisible(n) ? new CandidateElement(n, this.contentDocument) : null
	},
	canRunReaderDetection: function() {
		var e = this.contentDocument.location.hostname, t = this.contentDocument.location.pathname;
		for (var n in BlacklistedHostsAllowedPathRegexMap) {
			var r = new RegExp(n.escapeForRegExp());
			if (!r.test(e))
				continue;
			var i = BlacklistedHostsAllowedPathRegexMap[n];
			return i instanceof RegExp ? i.test(t) : !1
		}
		return !0
	},
	findArticleBySearchingAllElements: function(t) {
		var n = this.findSuggestedCandidate(), r = this.findCandidateElements();
		if (!r ||!r.length)
			return n;
		if (n && n.basicScore() >= ReaderMinimumScore)
			return n;
		var i = this.highestScoringCandidateFromCandidates(r);
		for (var s = i.element; s !== this.contentDocument; s = s.parentNode)
			if (s.tagName === "BLOCKQUOTE") {
				var o = s.parentNode, u = r.length;
				for (var a = 0; a < u; ++a) {
					var f = r[a];
					if (f.element === o) {
						i = f;
						break
					}
				}
				break
			}
		if (n && i.finalScore() < ReaderMinimumScore)
			return n;
		if (!t) {
			if (i.shouldDisqualifyDueToScoreDensity())
				return null;
			if (i.shouldDisqualifyDueToHorizontalRuleDensity())
				return null;
			if (i.shouldDisqualifyDueToHeaderDensity())
				return null;
			if (i.shouldDisqualifyDueToSimilarElements(r))
				return null
		}
		return i
	},
	findExtraArticle: function() {
		if (!this.article)
			return null;
		for (var t = 0, n = this.article.element; t < 3 && n; ++t, n = n.parentNode) {
			var r = this.findExtraArticleCandidateElements(n);
			if (!r ||!r.length)
				continue;
			var i = this.sortCandidateElementsInDescendingScoreOrder(r), s;
			for (var o = 0; o < i.length; o++) {
				s = i[o];
				if (!s ||!s.basicScore())
					break;
				if (s.shouldDisqualifyDueToScoreDensity())
					continue;
				if (s.shouldDisqualifyDueToHorizontalRuleDensity())
					continue;
				if (s.shouldDisqualifyDueToHeaderDensity())
					continue;
				if (cachedElementBoundingRect(s.element).height < PrependedArticleCandidateMinimumHeight && cachedElementBoundingRect(this.article.element).width !== cachedElementBoundingRect(s.element).width)
					continue;
				var u = contentTextStyleForNode(this.contentDocument, s.element);
				if (!u)
					continue;
				if (u.fontFamily !== this.contentTextStyle().fontFamily || u.fontSize !== this.contentTextStyle().fontSize)
					continue;
				if (s)
					return s
			}
		}
		return null
	},
	highestScoringCandidateFromCandidates: function(t) {
		var n = 0, r = null, i = t.length;
		for (var s = 0; s < i; ++s) {
			var o = t[s], u = o.basicScore();
			u >= n && (n = u, r = o)
		}
		return r
	},
	sortCandidateElementsInDescendingScoreOrder: function(t) {
		function n(e, t) {
			return e.basicScore() !== t.basicScore() ? t.basicScore() - e.basicScore() : t.depth() - e.depth()
		}
		return t.sort(n)
	},
	findCandidateElements: function() {
		const t = 1e3;
		var n = Date.now() + t, r = this.contentDocument.getElementsByTagName("*"), i = r.length, s = [];
		for (var o = 0; o < i; ++o) {
			var u = r[o];
			if (CandidateTagNamesToIgnore[u.tagName])
				continue;
			var a = CandidateElement.candidateIfElementIsViable(u, this.contentDocument);
			a && s.push(a);
			if (Date.now() > n) {
				s = [];
				break
			}
		}
		var f = s.length;
		for (var o = 0; o < f; ++o)
			s[o].element.candidateElement = s[o];
		for (var o = 0; o < f; ++o) {
			var l = s[o];
			if (l.element.tagName !== "BLOCKQUOTE")
				continue;
			var c = l.element.parentElement.candidateElement;
			if (!c)
				continue;
			c.addTextNodesFromCandidateElement(l)
		}
		for (var o = 0; o < f; ++o)
			s[o].element.candidateElement = null;
		return s
	},
	findExtraArticleCandidateElements: function(t) {
		if (!this.article)
			return [];
		t || (t = this.article.element);
		var n = "preceding-sibling::*/descendant-or-self::*", r = this.contentDocument.evaluate(n, t, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), i = r.snapshotLength, s = [];
		for (var o = 0; o < i; ++o) {
			var u = r.snapshotItem(o);
			if (CandidateTagNamesToIgnore[u.tagName])
				continue;
			var a = CandidateElement.extraArticleCandidateIfElementIsViable(u, this.article, this.contentDocument, !0);
			a && s.push(a)
		}
		n = "following-sibling::*/descendant-or-self::*", r = this.contentDocument.evaluate(n, t, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), i = r.snapshotLength;
		for (var o = 0; o < i; ++o) {
			var u = r.snapshotItem(o);
			if (CandidateTagNamesToIgnore[u.tagName])
				continue;
			var a = CandidateElement.extraArticleCandidateIfElementIsViable(u, this.article, this.contentDocument, !1);
			a && s.push(a)
		}
		return s
	},
	isGeneratedBy: function(t) {
		var n = this.contentDocument.head ? this.contentDocument.head.querySelector("meta[name=generator]"): null;
		if (!n)
			return !1;
		var r = n.content;
		return r ? t.test(r) : !1
	},
	isMediaWikiPage: function() {
		return this.isGeneratedBy(/^MediaWiki /)
	},
	isWordPressSite: function() {
		return this.isGeneratedBy(/^WordPress/)
	},
	nextPageURLString: function() {
		if (!this.article)
			return null;
		if (this.isMediaWikiPage())
			return null;
		var t, n = 0, r = this.article.element;
		r.parentNode && getComputedStyle(r).display === "inline" && (r = r.parentNode);
		var i = r, s = cachedElementBoundingRect(r).bottom + LinkMaxVerticalDistanceFromArticle;
		while (isElementNode(i) && cachedElementBoundingRect(i).bottom <= s)
			i = i.parentNode;
		i !== r && (i === this.contentDocument || isElementNode(i)) && (r = i);
		var o = this.contentDocument.evaluate(LinkCandidateXPathQuery, r, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), u = o.snapshotLength;
		if (this.pageNumber <= 2&&!this.prefixWithDateForNextPageURL) {
			var a = this.contentDocument.location.pathname, f = a.match(LinkDateRegex);
			f && (f = f[0], this.prefixWithDateForNextPageURL = a.substring(0, a.indexOf(f) + f.length))
		}
		for (var l = 0; l < u; ++l) {
			var c = o.snapshotItem(l), h = this.scoreNextPageLinkCandidate(c);
			h > n && (t = c, n = h)
		}
		return t ? t.href : null
	},
	scoreNextPageLinkCandidate: function(t) {
		function n(e, t, n, r) {
			t.substring(0, e.length) === e && (t = t.substring(e.length), e = "");
			var i = t.lastInteger();
			if (isNaN(i))
				return !1;
			var s = e ? e.lastInteger(): NaN;
			if (isNaN(s) || s >= MaximumExactIntegralValue)
				s = r;
			return i === s ? n.lastInteger() === s + 1 : i === s + 1
		}
		function r(e) {
			var t = {}, n = e.substring(1).split("&"), r = n.length;
			for (var i = 0; i < r; ++i) {
				var s = n[i], o = s.indexOf("=");
				o===-1 ? t[s] = null : t[s.substring(0, o)] = s.substring(o + 1)
			}
			return t
		}
		var i = this.contentDocument.location;
		if (t.host !== i.host)
			return 0;
		if (t.pathname === i.pathname && t.search === i.search)
			return 0;
		if (t.toString().indexOf("#")!==-1)
			return 0;
		if (anchorLinksToAttachment(t) || anchorLinksToTagOrCategoryPage(t))
			return 0;
		if (!isElementVisible(t))
			return 0;
		var s = cachedElementBoundingRect(t), o = this._articleBoundingRect, u = Math.max(0, Math.max(o.top - (s.top + s.height), s.top - (o.top + o.height)));
		if (s.top < o.top)
			return 0;
		if (u > LinkMaxVerticalDistanceFromArticle)
			return 0;
		var a = Math.max(0, Math.max(o.left - (s.left + s.width), s.left - (o.left + o.width)));
		if (a > 0)
			return 0;
		var f = i.pathname, l = t.pathname;
		if (this.prefixWithDateForNextPageURL) {
			if (t.pathname.indexOf(this.prefixWithDateForNextPageURL)===-1)
				return 0;
			f = f.substring(this.prefixWithDateForNextPageURL.length), l = l.substring(this.prefixWithDateForNextPageURL.length)
		}
		var c = l.substring(1).split("/");
		c[c.length - 1] || c.pop();
		var h = c.length, p = f.substring(1).split("/"), d=!1;
		p[p.length - 1] || (d=!0, p.pop());
		var v = p.length;
		if (h < v)
			return 0;
		var m = 0, g = 0, y = t.textContent;
		for (var b = 0; b < h; ++b) {
			var w = c[b], E = b < v ? p[b]: "";
			if (E !== w) {
				if (b < v - 2)
					return 0;
				if (w.length >= E.length) {
					var S = 0;
					while (w[w.length - 1 - S] === E[E.length - 1 - S])
						S++;
					S && (w = w.substring(0, w.length - S), E = E.substring(0, E.length - S));
					var x = w.indexOf(E);
					x!==-1 && (w = w.substring(x))
				}
				n(E, w, y, this.pageNumber) ? g = Math.pow(LinkNextOrdinalValueBase, b - h + 1) : m++
			}
			if (m > 1)
				return 0
		}
		var T=!1;
		if (t.search) {
			linkParameters = r(t.search), referenceParameters = r(i.search);
			for (var N in linkParameters) {
				var C = linkParameters[N], k = N in referenceParameters ? referenceParameters[N]: null;
				if (k !== C) {
					k === null && (k = ""), C === null && (C = "");
					if (C.length < k.length)
						m++;
					else if (n(k, C, y, this.pageNumber)) {
						if (LinkURLSearchParameterKeyMatchRegex.test(N)) {
							if (f.toLowerCase() !== l.toLowerCase())
								return 0;
							if (this.isWordPressSite() && d)
								return 0;
							T=!0
						}
						if (LinkURLBadSearchParameterKeyMatchRegex.test(N)) {
							m++;
							continue
						}
						g = Math.max(g, 1 / LinkNextOrdinalValueBase)
					} else
						m++
				}
			}
		}
		if (!g)
			return 0;
		if (LinkURLPageSlashNumberMatchRegex.test(t.href) || LinkURLSlashDigitEndMatchRegex.test(t.href))
			T=!0;
		if (!T && h === v && stringSimilarity(f, l) < LinkMinimumURLSimilarityRatio)
			return 0;
		if (LinkURLArchiveSlashDigitEndMatchRegex.test(t))
			return 0;
		var L = LinkMatchWeight * (Math.pow(LinkMismatchValueBase, - m) + g) + LinkVerticalDistanceFromArticleWeight * u / LinkMaxVerticalDistanceFromArticle;
		T && (L += LinkURLSemanticMatchBonus), t.parentNode.tagName === "LI" && (L += LinkListItemBonus);
		var y = t.innerText;
		return LinkNextMatchRegEx.test(y) && (L += LinkNextMatchBonus), LinkPageMatchRegEx.test(y) && (L += LinkPageMatchBonus), LinkContinueMatchRegEx.test(y) && (L += LinkContinueMatchBonus), L
	},
	elementContainsEnoughTextOfSameStyle: function(t) {
		function o(e, t) {
			function u(t) {
				var n = e.children[0];
				if (n) {
					var r = n.children, i = r.length;
					for (var s = 0; s < i; ++s)
						if (getComputedStyle(r[s]).float !== "none")
							return !1
				}
				return !0
			}
			function a(e, i) {
				if (e.nodeType === Node.TEXT_NODE) {
					/\S/.test(e.nodeValue) && r.push(e);
					return
				}
				if (e.nodeType !== Node.ELEMENT_NODE)
					return;
				if (!isElementVisible(e))
					return;
				if (t&&++n > t)
					return;
				if (e._evaluatedForTextContent)
					return;
				var f = e.tagName;
				if (f === "IFRAME" || f === "FORM")
					return;
				o[f] ? i-- : (f === "UL" || f === "OL") && u(e) && i--;
				var l = i + 1;
				if (l < s) {
					var c = e.childNodes, h = c.length;
					for (var p = 0; p < h; ++p)
						a(c[p], l)
				}
			}
			var n = 0, r = [], o = {
				P: 1,
				STRONG: 1,
				B: 1,
				EM: 1,
				I: 1,
				SPAN: 1
			};
			return i && (o.CENTER = 1, o.FONT = 1), a(e, 0), r
		}
		const n = 110, r = 1800;
		var i = t.tagName === "BODY", s = i ? 2: 3, u = o(t, n), a = r / scoreMultiplierForElementTagNameAndAttributes(t) / languageScoreMultiplierForTextNodes(u), f = {}, l = u.length;
		for (var c = 0; c < l; ++c) {
			var h = u[c], p = h.length, d = h.parentElement, v = window.getComputedStyle(d), m = v.fontFamily + "|" + v.fontSize, g = Math.pow(p, TextNodeLengthPower);
			if (f[m]) {
				if ((f[m] += g) > a)
					break
			} else
				f[m] = g
		}
		for (var m in f)
			if (f[m] > a)
				return !0;
		return !1
	},
	pointsToUseForHitTesting: function() {
		const t = window.innerWidth, n = t / 4, r = t / 2, i = 128, s = 320;
		return [[r, 800], [r, 600], [n, 800], [r, 400], [r - i, 1200], [s, 700], [3 * n, 800], [t - s, 700]]
	},
	clearVisualExaminationState: function() {
		var t = this._elementsEvaluatedForTextContent.length;
		for (var n = 0; n < t; ++n)
			delete this._elementsEvaluatedForTextContent[n]._evaluatedForTextContent;
		this._elementsEvaluatedForTextContent = []
	},
	findArticleByVisualExamination: function() {
		this.clearVisualExaminationState();
		var t = this.pointsToUseForHitTesting(), n = t.length;
		for (var r = 0; r < n; r++) {
			var i = t[r][0], s = t[r][1], o = elementAtPoint(i, s);
			for (var u = o; u; u = u.parentElement) {
				if (u._evaluatedForTextContent)
					break;
				if (VeryPositiveClassNameRegEx.test(u.className))
					return new CandidateElement(u, this.contentDocument);
				if (CandidateTagNamesToIgnore[u.tagName])
					continue;
				var a = u.offsetWidth, f = u.offsetHeight;
				if (!a&&!f) {
					var l = cachedElementBoundingRect(u);
					a = l.width, f = l.height
				}
				if (a < CandidateMinimumWidth || f < CandidateMinimumHeight || a * f < CandidateMinimumArea)
					continue;
				var c = this.elementContainsEnoughTextOfSameStyle(u);
				u._evaluatedForTextContent=!0, this._elementsEvaluatedForTextContent.push(u);
				if (!c)
					continue;
				if (CandidateElement.candidateElementAdjustedHeight(u) < CandidateMinimumHeight)
					continue;
				var h = new CandidateElement(u, this.contentDocument);
				if (h.shouldDisqualifyDueToSimilarElements())
					return null;
				if (h.shouldDisqualifyDueToHorizontalRuleDensity())
					return null;
				if (h.shouldDisqualifyDueToHeaderDensity())
					return null;
				if (h.shouldDisqualifyForDeepLinking())
					continue;
				return h
			}
		}
		return null
	},
	articleTextContent: function() {
		return this._articleTextContent
	},
	pageDescription: function() {
		var t = this.contentDocument.querySelectorAll("head meta[name]"), n = t.length;
		for (var r = 0; r < n; ++r) {
			var i = t[r];
			if (i.getAttribute("name").toLowerCase() === "description") {
				var s = i.getAttribute("content");
				if (s)
					return s.trim()
				}
		}
		return null
	},
	siteName: function() {
		function o(e, t) {
			const n = /^(www|m)\./;
			return e === t || e.replace(n, "") === t.replace(n, "")
		}
		const t = [" - ", " \u2013 ", " \u2014 ", ": ", " | ", " \u00bb "], n = t.length;
		var r = this.contentDocument.title, i = this.contentDocument.location.host, s = this.articleTitle(), u, a;
		for (var f = 0; f < n; ++f) {
			var l = t[f], c = r.split(l), h = c.length;
			if (h === 1)
				continue;
			for (var p = 0; p < h; ++p) {
				var d = c[p].trim();
				if (d === s)
					continue;
				if (o(d, i))
					continue;
				var v = stringSimilarity(d, i);
				if (!a || v > a)
					u = d, a = v
			}
		}
		return u || ""
	},
	readingListItemInformation: function() {
		const t = 220, n = 220;
		var r, i = this.pageDescription(), s=!1;
		this.adoptableArticle() ? (r = this.articleTitle(), i = i || this.articleTextContent(), s=!0) : (r = this.contentDocument.title, this.contentDocument.body && (i = i || this.contentDocument.body.innerText));
		var o = "", u = this.mainImageNode();
		return u && (o = u.src), r || (r = userVisibleURLString(this.contentDocument.location.href)), r = r.trim().substring(0, t), i || (i = ""), i = i.trim().substring(0, n).replace(/[\s]+/g, " "), {
			title: r,
			previewText: i,
			siteName: this.siteName(),
			mainImageURL: o,
			isReaderAvailable: s
		}
	}
};
var ReaderArticleFinderJS = new ReaderArticleFinder(document);


function getRootUrl()
{
    return window.location.origin
    ? window.location.origin + '/'
    : window.location.protocol + '/'+window.location.host + '/';
}


var OUExtensionJavaScriptClass = function() {};

OUExtensionJavaScriptClass.prototype =
{
    
run: function(arguments)
    {
        var url = window.location.href;
        var rootUrl = getRootUrl();
        var urlProtocol = window.location.protocol;
        var htmlText = '';
        var title = '';
		var selectionMode = false; //if user select something on a page
		var readerMode = false; //if reader mode is avaiable for current page, we extract only article in readable format
		
		title = document.title;
        
        if (document.selection && document.selection.createRange)
        {
            var range = document.selection.createRange();
            htmlText = range.htmlText;
			selectionMode = true;
        }
        else if (window.getSelection)
        {
            var selection = window.getSelection();
            if (selection.rangeCount > 0)
            {
                range = selection.getRangeAt(0);
                var clonedSelection = range.cloneContents();
                var div = document.createElement('div');
                div.appendChild(clonedSelection);
                htmlText = div.innerHTML;
				selectionMode = true;
            }
        }
        
        if (htmlText.length == 0)
        {
			if (ReaderArticleFinderJS.isReaderModeAvailable())
			{
				htmlText = ReaderArticleFinderJS.adoptableArticle(true).outerHTML;
				readerMode = true;
			}
			else
				htmlText = document.documentElement.innerHTML;
        }
		
		var processed = readerMode || selectionMode;
		
        arguments.completionFunction({'innerHTML': htmlText, 'rootUrl': rootUrl, 'url': url, 'urlProtocol' : urlProtocol, 'title': title, 'processed': processed});
    },
    
finalize: function(arguments)
    {
    }
    
};

var ExtensionPreprocessingJS = new OUExtensionJavaScriptClass;
